/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.inventory;

import cpw.mods.fml.relauncher.ReflectionHelper;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import speiger.src.crops.IC2NeiPlugin;
import speiger.src.crops.api.CropPluginAPI;
import speiger.src.crops.inventory.BreedingContainer;
import speiger.src.crops.inventory.CropList;
import speiger.src.crops.inventory.Tuple;

public class GuiBreeding
extends GuiContainer {
    static final ResourceLocation breedingUI = new ResourceLocation("ic2nei", "textures/breedingui.png");
    BreedingContainer container;
    CropList list;
    CropList results;

    public GuiBreeding(BreedingContainer inventorySlotsIn) {
        super((Container)inventorySlotsIn);
        this.container = inventorySlotsIn;
        this.list = IC2NeiPlugin.CROP_LIST;
        this.results = IC2NeiPlugin.RESULT_LIST;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButton(0, x + 7, y + 108, 10, 10, "<"));
        this.field_146292_n.add(new GuiButton(1, x + 158, y + 108, 10, 10, ">"));
        this.field_146292_n.add(new GuiButton(2, x + 30, y + 108, 40, 10, "Clear"));
        this.field_146292_n.add(new GuiButton(3, x + 100, y + 108, 50, 10, "Calculate"));
        this.field_146292_n.add(new GuiButton(4, x + 7, y + 27, 10, 10, "<"));
        this.field_146292_n.add(new GuiButton(5, x + 158, y + 27, 10, 10, ">"));
        this.list.update((IInventory)BreedingContainer.provided);
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 2) {
            BreedingContainer.calculator.clear();
            this.container.clearResults();
            this.results.clear();
        } else if (id == 3) {
            this.breed();
        } else if (id == 5) {
            this.list.increase(1);
            this.list.update((IInventory)BreedingContainer.provided);
        } else if (id == 4) {
            this.list.decrease(1);
            this.list.update((IInventory)BreedingContainer.provided);
        } else if (id == 1) {
            this.results.increase(1);
            this.results.update((IInventory)BreedingContainer.result);
        } else if (id == 0) {
            this.results.decrease(1);
            this.results.update((IInventory)BreedingContainer.result);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.update();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void update() {
        ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = this.canBreed();
        Slot slot = this.getSlotUnderMouse();
        if (slot instanceof BreedingContainer.SlotResult) {
            int amount = -(Mouse.getDWheel() / 120);
            if (slot.field_75222_d < 9) {
                this.list.increase(amount);
                this.list.update((IInventory)BreedingContainer.provided);
                return;
            }
            this.results.increase(amount);
            this.results.update((IInventory)BreedingContainer.result);
            return;
        }
    }

    public boolean canBreed() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (BreedingContainer.calculator.func_70301_a(i) == null) continue;
            ++count;
        }
        return count > 1;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(breedingUI);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146984_a(Slot slotIn, int slotId, int mouseButton, int type) {
        if (slotIn != null) {
            slotId = slotIn.field_75222_d;
        }
        this.field_146297_k.field_71439_g.field_71070_bA.func_75144_a(slotId, mouseButton, type, (EntityPlayer)this.field_146297_k.field_71439_g);
    }

    public void breed() {
        CropCard[] crops = BreedingContainer.calculator.getCrops();
        ArrayList<CropCard> toBreed = new ArrayList<CropCard>();
        for (int i = 0; i < crops.length; ++i) {
            if (crops[i] == null) continue;
            toBreed.add(crops[i]);
        }
        ArrayList<CropCard> resultList = new ArrayList<CropCard>(IC2NeiPlugin.ALL_CROPS);
        resultList.remove(Crops.weed);
        int[] ratios = new int[resultList.size()];
        int total = 0;
        for (int i = 0; i < resultList.size(); ++i) {
            CropCard card = (CropCard)resultList.get(i);
            for (int j = 0; j < toBreed.size(); ++j) {
                int chance = GuiBreeding.calculateRatioFor(card, (CropCard)toBreed.get(j));
                int n = i;
                ratios[n] = ratios[n] + chance;
                total += chance;
            }
        }
        ArrayList<Tuple<CropCard, ItemStack>> dataList = new ArrayList<Tuple<CropCard, ItemStack>>();
        for (int i = 0; i < resultList.size(); ++i) {
            if (ratios[i] <= 0) continue;
            float percent = (float)ratios[i] / (float)total * 100.0f;
            ItemStack stack = this.getCrop((CropCard)resultList.get(i));
            ArrayList<String> s = new ArrayList<String>();
            s.add(EnumChatFormatting.GREEN + "Points: " + ratios[i]);
            s.add(EnumChatFormatting.GOLD + "Chance: " + ItemStack.field_111284_a.format(percent) + "%");
            this.addToolTip(stack, s);
            GuiBreeding.getOrCreateNbtData(stack).func_74768_a("Points", ratios[i]);
            dataList.add(new Tuple(resultList.get(i), stack));
        }
        dataList.sort(new Comparator<Tuple<CropCard, ItemStack>>(){

            @Override
            public int compare(Tuple<CropCard, ItemStack> o1, Tuple<CropCard, ItemStack> o2) {
                int secondPoints;
                int firstPoints = this.getPoints(o1.getValue());
                if (firstPoints > (secondPoints = this.getPoints(o2.getValue()))) {
                    return -1;
                }
                if (secondPoints > firstPoints) {
                    return 1;
                }
                return 0;
            }

            public int getPoints(ItemStack stack) {
                return GuiBreeding.getOrCreateNbtData(stack).func_74762_e("Points");
            }
        });
        this.results.clear();
        this.results.addAll(dataList);
        this.results.update((IInventory)BreedingContainer.result);
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        super.func_146285_a(stack, x, y);
    }

    public Slot getSlotUnderMouse() {
        try {
            return (Slot)ReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((Object)this), (String[])new String[]{"theSlot", "field_147006_u"});
        }
        catch (Exception var2) {
            return null;
        }
    }

    private ItemStack getCrop(CropCard card) {
        ItemStack stack = CropPluginAPI.instance.getDisplayItem(card);
        if (stack == null) {
            stack = IC2NeiPlugin.DISPLAY_ITEMS.get(card);
        }
        return stack.func_77946_l();
    }

    public static int calculateRatioFor(CropCard a, CropCard b) {
        if (a == b) {
            return 500;
        }
        int value = 0;
        for (int i = 0; i < 5; ++i) {
            value += -Math.abs(a.stat(i) - b.stat(i)) + 2;
        }
        for (int x = 0; x < a.attributes().length; ++x) {
            String one = a.attributes()[x];
            for (int y = 0; y < b.attributes().length; ++y) {
                String two = b.attributes()[y];
                if (!one.equalsIgnoreCase(two)) continue;
                value += 5;
            }
        }
        int diff = a.tier() - b.tier();
        if (diff > 1) {
            value -= 2 * diff;
        }
        if (diff < -3) {
            value -= -diff;
        }
        if (value < 0) {
            value = 0;
        }
        return value;
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public void addToolTip(ItemStack stack, List<String> tips) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("display")) {
            stack.func_77978_p().func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p().func_74775_l("display");
        NBTTagList list = nbt.func_150295_c("Lore", 8);
        for (String s : tips) {
            list.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.RESET + s + EnumChatFormatting.RESET));
        }
        nbt.func_74782_a("Lore", (NBTBase)list);
    }
}

